'use strict';

/* --------------------------------------------------------------
 order_customizer.js 2017-05-24 gm
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2017 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * ## Orders Modal Layer Module
 *
 * This module will open a modal layer for order actions like deleting or changing the oder status.
 *
 * @module Compatibility/order_customizer
 */
gx.compatibility.module('order_customizer', [],

/**  @lends module:Compatibility/order_customizer */

function (data) {

    'use strict';

    // ------------------------------------------------------------------------
    // VARIABLES DEFINITION
    // ------------------------------------------------------------------------

    var
    /**
     * Module Selector
     *
     * @var {object}
     */
    $this = $(this),


    /**
     * Default Options
     *
     * @type {object}
     */
    defaults = {},


    /**
     * Final Options
     *
     * @var {object}
     */
    options = $.extend(true, {}, defaults, data),


    /**
     * Module Object
     *
     * @type {object}
     */
    module = {};

    // ------------------------------------------------------------------------
    // PRIVATE FUNCTIONS
    // ------------------------------------------------------------------------

    var _openCustomizerSet = function _openCustomizerSet(event) {

        var $customizer = $(options.selector);

        $('select[id^="element_"]').each(function (j) {
            var attr_id = $(this).attr('id');
            var attr_class = $(this).attr('class');
            var attr_name = $(this).attr('name');
            var attr_style = $(this).attr('style');
            var attr_value = $(this).children('option').val();

            $(this).replaceWith('<input type="text" name="' + attr_name + '" id="' + attr_id + '" class="' + attr_class + '" style="' + attr_style + '" value="' + attr_value + '">');
        });

        event.preventDefault();
        event.stopPropagation();
        $customizer.dialog({
            'title': jse.core.lang.translate('HEADING_GX_CUSTOMIZER', 'orders'),
            'modal': true,
            'dialogClass': 'gx-container',
            'buttons': [{
                'text': jse.core.lang.translate('save', 'buttons'),
                'class': 'btn',
                'click': function click() {
                    var content_div = $customizer.children('[id^="gm_gprint_content"]');
                    var _error = false;
                    content_div.children('[id^="surface_"]').each(function (i) {
                        var surface_id = $(this).attr('id');
                        var inputs = {};
                        var container_div = $(this).children('[id^="element_container_"]');

                        container_div.children('input[id^="element_"]').each(function (j) {
                            var input_id = $(this).attr('id');
                            var input = {};
                            input.id = input_id.substring(input_id.lastIndexOf('_') + 1);
                            input.value = $(this).val();
                            inputs[input_id] = input;
                        });
                        container_div.children('textarea[id^="element_"]').each(function (j) {
                            var input_id = $(this).attr('id');
                            var input = {};
                            input.id = input_id.substring(input_id.lastIndexOf('_') + 1);
                            input.value = $(this).val();
                            inputs[input_id] = input;
                        });

                        if (Object.keys(inputs).length > 0) {
                            $.ajax({
                                type: 'POST',
                                url: 'request_port.php?module=GPrintOrder&action=save_surfaces_group_inputs',
                                dataType: 'json',
                                context: this,
                                async: false,
                                data: {
                                    "inputs": inputs,
                                    "surface_id": surface_id.substring(surface_id.lastIndexOf('_') + 1)
                                },
                                success: function success() {
                                    console.log('gut');
                                },
                                error: function error() {
                                    console.log('error');
                                    _error = true;
                                }
                            });
                        }
                    });

                    if (_error) {
                        alert(jse.core.lang.translate('GM_GPRINT_SAVE_FAILED', 'admin_gm_gprint'));
                    } else {
                        alert(jse.core.lang.translate('GM_GPRINT_SAVE_SUCCESSFULL', 'admin_gm_gprint'));
                    }
                }
            }, {
                'text': jse.core.lang.translate('close', 'buttons'),
                'class': 'btn',
                'click': function click() {
                    $(this).dialog('close');
                }
            }],
            'width': 420,
            open: function open() {
                this.style.overflow = '';
            }
        });
    };

    // ------------------------------------------------------------------------
    // INITIALIZATION
    // ------------------------------------------------------------------------

    module.init = function (done) {
        $this.on('click', _openCustomizerSet);
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
